package gov.va.med.mhv.rxrefill.dto;

import gov.va.med.mhv.common.api.dto.UserProfileDTO;
import gov.va.med.mhv.rxrefill.enums.CategoryTypeEnumeration;
import gov.va.med.mhv.rxrefill.utils.WebUtility;

import java.io.Serializable;
import java.util.Date;

public class MedicationHistoryDTO implements Serializable {

	private static final long serialVersionUID = -989471761263391884L;
	private static final String DISP_DATE_FORMAT = "MM/dd/yyyy";

	private Long medicationId;
	private String comments;
	private String reason;
	private Date startDate;
	private String strength;
	private String pharmacyPhone;
	private String dosage;
	private String frequency;
	private String category;
	private String prescriptionNumber;
	private Date endDate;
	private String medicationName;
	private String pharmacyName;
	private Long userId;
	private UserProfileDTO userProfile;
	
	private String dispStartDate;
	private String dispEndDate;
	private String dispCategory;
		
	public Long getMedicationId() {
		return medicationId;
	}

	public void setMedicationId(Long medicationId) {
		this.medicationId = medicationId;
	}

	public String getComments() {
		return comments;
	}

	public void setComments(String comments) {
		this.comments = comments;
	}

	public String getReason() {
		return reason;
	}

	public void setReason(String reason) {
		this.reason = reason;
	}

	public Date getStartDate() {
		return startDate;
	}

	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}

	public String getStrength() {
		return strength;
	}

	public void setStrength(String strength) {
		this.strength = strength;
	}

	public String getPharmacyPhone() {
		return pharmacyPhone;
	}

	public void setPharmacyPhone(String pharmacyPhone) {
		this.pharmacyPhone = pharmacyPhone;
	}

	public String getDosage() {
		return dosage;
	}

	public void setDosage(String dosage) {
		this.dosage = dosage;
	}

	public String getFrequency() {
		return frequency;
	}

	public void setFrequency(String frequency) {
		this.frequency = frequency;
	}

	public String getCategory() {
		return category;
	}

	public void setCategory(String category) {
		this.category = category;
	}

	public String getPrescriptionNumber() {
		return prescriptionNumber;
	}

	public void setPrescriptionNumber(String prescriptionNumber) {
		this.prescriptionNumber = prescriptionNumber;
	}

	public Date getEndDate() {
		return endDate;
	}

	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}

	public String getMedicationName() {
		return medicationName;
	}

	public void setMedicationName(String medicationName) {
		this.medicationName = medicationName;
	}

	public String getPharmacyName() {
		return pharmacyName;
	}

	public void setPharmacyName(String pharmacyName) {
		this.pharmacyName = pharmacyName;
	}

	public Long getUserId() {
		return userId;
	}

	public void setUserId(Long userId) {
		this.userId = userId;
	}

	public UserProfileDTO getUserProfile() {
		return userProfile;
	}

	public void setUserProfile(UserProfileDTO userProfile) {
		this.userProfile = userProfile;
	}
	
	public String getDispStartDate() {
		return dispDate(this.startDate);
	}
	
	public String getDispEndDate() {
		return dispDate(this.endDate);
	}
	
	public String getDispCategory() {
		return CategoryTypeEnumeration.getValue(this.category);
	}
	
	private String dispDate(Date date) {
		return (null != date) ? WebUtility.dateToString(date, DISP_DATE_FORMAT) : "";
	}

}
